(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     84375,       2391]*)
(*NotebookOutlinePosition[     85968,       2439]*)
(*  CellTagsIndexPosition[     85894,       2433]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Rotacional y divergencia", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  TextAlignment->Right,
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(Off[ParametricPlot::ppcom]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{
      RowBox[{\(ortogonal[x_, y_] := \(x . y\/y . y\) y\), " ", 
        RowBox[{"(*", " ", 
          RowBox[{
          "calcula", " ", "la", " ", "proyecci\[OAcute]n", " ", "ortogonal", 
            " ", "de", " ", "un", " ", "vector", " ", 
            StyleBox["x",
              FontSlant->"Italic"], " ", "sobre", " ", "un", " ", "vector", 
            " ", "y"}], " ", "*)"}], "\n", \(norma[x_] := N[\@\(x . x\)]\), 
        "\n", \(vector2D[x_: {0, 0}, y_] := Arrow[x, x + y]\)}], 
      " ", \( (*\ traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x . \ 
              Por\ defecto\ x = {0, 0}\ *) \)}]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(campovectorial := 
      Module[{F}, F[x_, y_] = {0.5 \((y - 1)\), 0.3 \((x - 0.5)\)}; \n
        Show[Graphics[
            Table[{Red, 
                Arrow[{x, y}, {x, y} + F[x, y], \ 
                  HeadScaling\  -> \ Relative, 
                  HeadWidth ->  .3]}, {x, \(-2\), 2,  .25}, {y, \(-2\), 
                2,  .25}]], Axes -> True, 
          ImageSize -> {437, \ 378}]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(circulacionelipse\)\(:=\)\(Module[{\[Gamma], x, y, proy, flechas, 
          F}, \[Gamma][t_] := {1, 0} + {2  Cos[t], Sin[t]}; \n
        x[t_] := 1 + 2  Cos[t]; \ 
        y[t_] := Sin[t]; \[IndentingNewLine]F[x_, y_] = {0.5 \((y - 1)\), 
            0.3 \((x - 0.5)\)}; \n
        proy[t_] := ortogonal[F[x[t], y[t]], \(\[Gamma]'\)[t]]; \n
        flechas[t_] = {{Blue, vector2D[\[Gamma][t], \(\[Gamma]'\)[t]]}, {Red, 
              vector2D[\[Gamma][t], F[x[t], y[t]]]}, {Red, PointSize[ .02], 
              Point[\[Gamma][t]]}, {vector2D[\[Gamma][t], proy[t]]}}; \n
        ParametricPlot[\[Gamma][t], {t, 0, 2  \[Pi]}, 
          PlotStyle -> {Green, Thickness[0.01]}, 
          Epilog -> {flechas[ .15  \[Pi]], 
              flechas[1.75  \[Pi]], {Blue, 
                Arrow[\[Gamma][1.85], \[Gamma][1.86], 
                  HeadLength \[Rule]  .04], 
                Arrow[\[Gamma][4.85], \[Gamma][4.86], 
                  HeadLength \[Rule]  .04]}}, 
          PlotRange -> {{\(-1.1\), 3.9}, {\(-1.1\), 1.5}}, \ 
          ImageSize -> {403.5, \ 
              227.938}]\[IndentingNewLine]]\)\(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\
\)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(normaliza[x_]\  := \ x/N[norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    tgtunit[func_, 
        t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\), "\n", 
    \(normalunitexterior[func_, t_] := 
      Reverse[tgtunit[func, t]*{\(-1\), 1}]\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(flujoelipse\)\(:=\)\(Module[{proy, flechas, F, \[Gamma], x, 
          y}, \[Gamma][t_] = {1 + 2  Cos[t], Sin[t]}; \[IndentingNewLine]x[
            t_] = 1 + 2  Cos[t]; \ 
        y[t_] = Sin[t]; \[IndentingNewLine]F[x_, y_] = {0.5 \((y - 1)\), 
            0.3 \((x - 0.5)\)}; \[IndentingNewLine]proy[t_] := 
          ortogonal[F[x[t], y[t]], normalunitexterior[\[Gamma], t]]; \n
        flechas[t_] = {{Blue, 
              vector2D[\[Gamma][t], normalunitexterior[\[Gamma], t]]}, {Red, 
              vector2D[\[Gamma][t], F[x[t], y[t]]]}, {Red, PointSize[ .02], 
              Point[\[Gamma][t]]}, {vector2D[\[Gamma][t], proy[t]]}}; \n
        ParametricPlot[\[Gamma][t], {t, 0, 2  \[Pi]}, 
          PlotStyle -> {Green, Thickness[0.01]}, 
          Epilog -> {flechas[ .25  \[Pi]], 
              flechas[1.75  \[Pi]], {Blue, 
                Arrow[\[Gamma][1.85], \[Gamma][1.86], HeadLength ->  .04], 
                Arrow[\[Gamma][4.85], \[Gamma][4.86], HeadLength ->  .04]}}, 
          PlotRange -> {{\(-1.1\), 3.2}, {\(-1.6\), 1.6}}, \ 
          ImageSize -> {404, \ 
              228}]\[IndentingNewLine]]\)\(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\)\
\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Rotacional y divergencia de un campo vectorial", "Section"],

Cell["\<\
Para dar una interpretaci\[OAcute]n intuitiva del significado f\[IAcute]sico \
del rotacional y de la divergencia de un campo vectorial es conveniente \
considerar en primer lugar campos bidimensionales.\
\>", "Text"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " un campo vectorial de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  ", sea \[Gamma] un camino cerrado simple positivamente orientado y ",
  StyleBox["D",
    FontSlant->"Italic"],
  " la regi\[OAcute]n del plano limitada por \[Gamma]. El teorema de Green \
afirma que "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["D",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["Q",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["P",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["y",
                          FontSlant->"Italic"]}]], \((x, y)\)}]}], ")"}], 
              \(\[DifferentialD]\((x, y)\)\), 
              "                               ", \((1)\)}]}]}]}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como ya sabes, la integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  " se llama circulaci\[OAcute]n del campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " a lo largo de \[Gamma]. Para dar una interpretaci\[OAcute]n de dicha \
integral consideremos que el campo  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " es el campo de velocidades de un fluido plano, esto es,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(x, y\), ")"}], TraditionalForm]]],
  " es el vector velocidad del fluido en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". Se supone que la velocidad no depende del tiempo sino solamente de las \
coordenadas espaciales del punto, es decir, que se trata de un fluido \
estacionario. En cada punto \[Gamma](t) del camino \[Gamma] la velocidad del \
fluido es ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)); la proyecci\[OAcute]n ortogonal de dicho vector sobre el \
vector tangente a \[Gamma] en el punto \[Gamma](t) es el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(\[Gamma](t)\), ")"}], " ", "|", 
              " ", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], 
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], \((t)\)}], "=", 
          FormBox[\(\[Gamma]\ ' \(\((t)\)/\) || \[Gamma]\ ' \((t)\) || \),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Este vector tiene el mismo sentido que el vector tangente si el n\
\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[LeftAngleBracket]", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(\[Gamma](t)\), ")"}], " ", "|", 
            " ", \(\[Gamma]' \((t)\)\)}], "\[RightAngleBracket]"}], 
        TraditionalForm]]],
  " es positivo y distinto sentido cuando dicho n\[UAcute]mero es negativo; \
en el primer caso la velocidad del fluido en el punto \[Gamma](t) va en el \
mismo sentido que el del recorrido de la curva y en el segundo caso la \
velocidad del fluido en el punto \[Gamma](t) va en sentido opuesto al del \
recorrido de la curva. "
}], "Text"],

Cell["La siguiente gr\[AAcute]fica muestra un campo vectorial.", "Text"],

Cell[BoxData[
    \(\(campovectorial;\)\)], "Input"],

Cell["\<\
La siguiente gr\[AAcute]fica muestra una curva cerrada simple positivamente \
orientada (una elipse); en dos puntos de la misma se representan los vectores \
del campo anterior en rojo, los vectores tangente en azul y las proyecciones \
ortogonales de los primeros sobre los segundos en negro. En uno de los puntos \
la proyecci\[OAcute]n ortogonal tiene el mismo sentido que el vector tangente \
y en el otro tiene sentido opuesto.\
\>", "Text"],

Cell[BoxData[
    \(\(circulacionelipse;\)\)], "Input"],

Cell[TextData[{
  "Puesto que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                  "|", " ", \(\[Gamma]' \((t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}]}], 
        TextForm]]],
  ", si el valor de esta integral es positivo esto nos dice que el fluido \
circula a lo largo de la curva \[Gamma] en el mismo sentido que el definido \
por la orientaci\[OAcute]n de \[Gamma] y si el valor de esta integral es \
negativo entonces el fluido circula a lo largo de la curva \[Gamma] en \
sentido opuesto al de la orientaci\[OAcute]n de \[Gamma]. Si el valor de la \
integral es nulo es porque no hay circulaci\[OAcute]n neta del fluido a lo \
largo de \[Gamma].\nSupongamos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\[Integral]\_\[Gamma]\), 
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"]}],
            "TextForm"], ">", "0"}], TraditionalForm]]],
  ". En tal caso, por la continuidad del campo, se verificar\[AAcute] tambi\
\[EAcute]n que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Sigma]\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], ">", "0"}], TextForm]]],
  " para todo camino cerrado simple \[Sigma] positivamente orientado que est\
\[EAcute] \"suficientemente pr\[OAcute]ximo\" al camino \[Gamma]. Deducimos \
que en este caso se formar\[AAcute] en las proximidades de \[Gamma] un peque\
\[NTilde]o tubo que el fluido recorrer\[AAcute] en sentido antihorario. \n\
Consideremos ahora la igualdad (1) y supongamos que en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " se verifica que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((a, b)\),
                FontSlant->"Italic"]}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                StyleBox[\(a, b\),
                  FontSlant->"Italic"], ")"}]}]}], ">", "0"}], TextForm]]],
  ". Entonces, por la continuidad de las derivadas parciales, se tendr\
\[AAcute] que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["Q",
                      FontSlant->"Italic"]}], 
                  RowBox[{"\[PartialD]", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["P",
                      FontSlant->"Italic"]}], 
                  RowBox[{"\[PartialD]", 
                    StyleBox["y",
                      FontSlant->"Italic"]}]], \((x, y)\)}]}],
            "TextForm"], ">", "0"}], TraditionalForm]]],
  " para todo punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " en un disco centrado en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " de radio suficientemente peque\[NTilde]o. Si \[Gamma] es cualquier camino \
de Jordan contenido en dicho disco, se deduce de dicha igualdad que la \
circulaci\[OAcute]n del campo a lo largo de dicho camino ser\[AAcute] en \
sentido antihorario y concluimos que en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " se formar\[AAcute] un peque\[NTilde]o remolino.\nUna propiedad, \
f\[AAcute]cil de justificar, de las integrales dobles afirma que si ",
  StyleBox["h ",
    FontSlant->"Italic"],
  "es una funci\[OAcute]n continua en una regi\[OAcute]n del plano ",
  StyleBox["D",
    FontSlant->"Italic"],
  " cerrada y acotada entonces hay alg\[UAcute]n punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((a, b)\)\(\[Element]\)\(D\)\(\ \)\)\)]],
  "para el que se verifica la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(\[Integral]\_D\ \(h(x, 
                y)\) \[DifferentialD]\((x, y)\)\) = \(h(a, 
            b)\) \(\[CapitalAAcute]rea(D)\)\)]],
  ".\nUsando esta propiedad y de la igualdad (1) es f\[AAcute]cil probar que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(lim\_\(\[Rho] \[Rule] 0\)\), 
            RowBox[{\(1\/\[Pi]\[Rho]\^2\), 
              RowBox[{\(\[Integral]\_\(C \((\((a, b)\), \[Rho])\)\)\), 
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((a, b)\),
                FontSlant->"Italic"]}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((a, b)\),
                FontSlant->"Italic"]}]}]}], "                           "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El n\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"]}], "-", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"]}]}], TextForm]]],
  " se llama rotaci\[OAcute]n del campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". Se dice que el campo es ",
  StyleBox["irrotacional",
    FontWeight->"Bold"],
  " cuando ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"]}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"]}]}], "=", "0"}], TextForm]]],
  " para todo punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " de su dominio de definici\[OAcute]n. "
}], "Text"],

Cell[TextData[{
  "Como consecuencia tambi\[EAcute]n del teorema de Green, sin m\[AAcute]s \
que cambiar ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " por ",
  StyleBox["P",
    FontSlant->"Italic"],
  " y ",
  StyleBox["P",
    FontSlant->"Italic"],
  " por -",
  StyleBox["Q",
    FontSlant->"Italic"],
  ", se verifica la igualdad"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["y",
                  FontSlant->"Italic"]}]}]}], "-", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["x",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["D",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["P",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          FontSlant->"Italic"]}]], \((x, y)\)}], "+", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["Q",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["y",
                          FontSlant->"Italic"]}]], \((x, y)\)}]}], 
                ")"}], \(\[DifferentialD]\((x, y)\)\), 
              "                               ", \((2)\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Pongamos ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ". Tenemos que:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["y",
                  FontSlant->"Italic"]}]}]}], "-", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["x",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["P",
                        FontSlant->"Italic"], "(", \(x(t), y(t)\), 
                      ")"}], \(y'\), \((t)\)}], "-", 
                  RowBox[{
                    RowBox[{
                      StyleBox["Q",
                        FontSlant->"Italic"], "(", \(x(t), y(t)\), 
                      ")"}], \(x'\), \((t)\)}]}], 
                ")"}], \(\[DifferentialD]t\)}]}], "  ", "=", "  ", 
          RowBox[{
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), "    ", 
                RowBox[{
                  StyleBox["\[LeftAngleBracket]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    RowBox[{
                      RowBox[{\(P(x(t), y(t))\), 
                        StyleBox["i",
                          FontWeight->"Bold",
                          FontSlant->"Italic"]}], 
                      StyleBox[" ",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "+", " ", 
                      RowBox[{\(Q(x(t), y(t))\), " ", 
                        StyleBox["j",
                          FontWeight->"Bold",
                          FontSlant->"Italic"]}]}], "|", "  ", 
                    FractionBox[
                      RowBox[{
                        RowBox[{\(y'\), \((t)\), " ", 
                          StyleBox["i",
                            FontWeight->"Bold",
                            FontSlant->"Italic"]}], 
                        StyleBox["-",
                          FontSlant->"Italic"], 
                        RowBox[{\(x'\), \((t)\), 
                          StyleBox["j",
                            FontWeight->"Bold",
                            FontSlant->"Italic"]}]}], 
                      RowBox[{"||", 
                        RowBox[{
                          RowBox[{\(y'\), \((t)\), " ", 
                            StyleBox["i",
                              FontWeight->"Bold",
                              FontSlant->"Italic"]}], 
                          StyleBox["-",
                            FontSlant->"Italic"], 
                          RowBox[{\(x'\), \((t)\), 
                            StyleBox["j",
                              FontWeight->"Bold",
                              FontSlant->"Italic"]}]}], "||"}]]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}], " ", "||", 
              RowBox[{
                RowBox[{\(x'\), \((t)\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], "+", 
                RowBox[{\(y'\), \((t)\), 
                  StyleBox["j",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}], "||", \(\[DifferentialD]t\)}], 
            "=", 
            RowBox[{
              RowBox[{
                RowBox[{\(\[Integral]\_a\%b\), " ", 
                  RowBox[{"\[LeftAngleBracket]", 
                    RowBox[{
                      RowBox[{
                        StyleBox["F",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], "(", \(\[Gamma](t)\), ")"}], 
                      "|", 
                      RowBox[{
                        StyleBox["n",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], "(", "t", ")"}]}], 
                    "\[RightAngleBracket]"}]}], "||", \(\[Gamma]' \((t)\)\), 
                "||", \(\[DifferentialD]t\)}], "=", 
              RowBox[{\(\[Integral]\_\[Gamma]\), 
                StyleBox[\(F . n\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde hemos representado por ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t) el vector unitario normal a la curva \[Gamma] en el punto \[Gamma](t) \
que apuntan hacia el exterior de la misma. Supuesto que la curva est\[AAcute] \
orientada positivamente, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " viene dado por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", "t", ")"}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{
              RowBox[{\(y'\), \((t)\), " ", 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox["-",
                FontSlant->"Italic"], 
              RowBox[{\(x'\), \((t)\), 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}], 
            RowBox[{"||", 
              RowBox[{
                RowBox[{\(y'\), \((t)\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], 
                StyleBox["-",
                  FontSlant->"Italic"], 
                RowBox[{\(x'\), \((t)\), 
                  StyleBox["j",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}], "||"}]], "=", 
          FractionBox[
            RowBox[{
              RowBox[{\(y'\), \((t)\), " ", 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox["-",
                FontSlant->"Italic"], 
              RowBox[{\(x'\), \((t)\), 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}], 
            RowBox[{"||", 
              RowBox[{
                RowBox[{\(x'\), \((t)\), " ", 
                  StyleBox["i",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], "+", 
                RowBox[{\(y'\), \((t)\), 
                  StyleBox["j",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}], "||"}]]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
La siguiente gr\[AAcute]fica muestra una curva cerrada simple positivamente \
orientada (una elipse); en dos puntos de la misma se representan los vectores \
del campo antes considerado en rojo, los vectores normales unitarios \
exteriores en azul y las proyecciones ortogonales de los primeros sobre los \
segundos en negro. En uno de los puntos la proyecci\[OAcute]n ortogonal tiene \
el mismo sentido que el vector normal exterior y en el otro tiene sentido \
opuesto.\
\>", "Text"],

Cell[BoxData[
    \(\(flujoelipse;\)\)], "Input"],

Cell[TextData[{
  "Al igual que la proyecci\[OAcute]n ortogonal del vector campo sobre el \
vector tangente a la curva mide la circulaci\[OAcute]n del fuido a lo largo \
de la curva, la proyecci\[OAcute]n ortogonal del vector campo sobre el vector \
normal exterior a la curva mide el ",
  StyleBox["flujo de fluido ",
    FontWeight->"Bold"],
  StyleBox["a trav\[EAcute]s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" de la curva",
    FontWeight->"Bold"],
  ", por ello, se define el ",
  StyleBox["flujo del campo ",
    FontWeight->"Bold"],
  StyleBox["a trav\[EAcute]s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" del camino \[Gamma]",
    FontWeight->"Bold"],
  " como la integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox[\(F . n\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  ". Si dicha integral es positiva eso significa que sale m\[AAcute]s fluido \
del que entra (por lo que dentro de la curva debe haber manantiales) y si es \
negativa significa que sale menos fluido del que entra (por lo que dentro de \
la curva debe haber sumideros). "
}], "Text"],

Cell["Hemos justificado la igualdad", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["y",
                  FontSlant->"Italic"]}]}]}], "-", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["x",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            StyleBox[\(F . n\),
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["D",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      FractionBox[
                        RowBox[{"\[PartialD]", 
                          StyleBox["P",
                            FontSlant->"Italic"]}], 
                        RowBox[{"\[PartialD]", 
                          StyleBox["x",
                            FontSlant->"Italic"]}]], \((x, y)\)}], "+", 
                    RowBox[{
                      FractionBox[
                        RowBox[{"\[PartialD]", 
                          StyleBox["Q",
                            FontSlant->"Italic"]}], 
                        RowBox[{"\[PartialD]", 
                          StyleBox["y",
                            FontSlant->"Italic"]}]], \((x, y)\)}]}], 
                  ")"}], \(\(\[DifferentialD]\)\((x, 
                    y)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \)\)}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
A partir de aqu\[IAcute] podemos razonar como lo hicimos anteriormente para \
obtener que\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(lim\_\(\[Rho] \[Rule] 0\)\), 
            RowBox[{\(1\/\[Pi]\[Rho]\^2\), 
              RowBox[{\(\[Integral]\_\(C \((\((a, b)\), \[Rho])\)\)\), 
                StyleBox[\(F . n\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((a, b)\),
                FontSlant->"Italic"]}], "+", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((a, b)\),
                FontSlant->"Italic"]}]}]}], "                           "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El n\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"]}], "+", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"]}]}], TextForm]]],
  " se llama divergencia del campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". Donde la divergencia es positiva hay manantiales y el fluido ",
  StyleBox["diverge",
    FontSlant->"Italic"],
  " hacia otros lados y donde la divergencia es negativa hay sumideros y el \
fluido ",
  StyleBox["converge",
    FontSlant->"Italic"],
  " hacia ellos. Se dice que el campo es incompresible cuando su divergencia \
es id\[EAcute]nticamente nula. "
}], "Text"],

Cell["\<\
En el siguiente ejemplo se pone de manifiesto lo que acabamos de afirmar.\
\>", "Text"],

Cell[BoxData[{
    \(F[x_, y_] := {Sin[x], Cos[y]}\), "\n", 
    \(\(Show[
        Graphics[
          Table[{Red, 
              Arrow[{x, y}, {x, y} + F[x, y], \ HeadScaling\  -> \ Relative, 
                HeadWidth ->  .3]}, {x, \(-5\), 5,  .5}, {y, \(-8\), 
              5,  .5}]], Axes -> True, 
        ImageSize -> {437, \ 378}];\)\), "\n", 
    \(Clear[F]\)}], "Input"],

Cell["\<\
Observa que hay puntos a los que los vectores de este campo parecen dirigirse \
(por ejemplo, los puntos (3.1,1.6), (3.1,-4.7) y sus sim\[EAcute]tricos \
respecto al eje de ordenadas) y otros en los que el campo parece estar \
divergiendo (por ejemplo, los puntos (0,1.5), (0,-1.5) , (.5,-4.5)). Si este \
campo lo interpretamos como el campo de velocidades de un fluido \
estacionario, las zonas hacia donde se dirigen los vectores son sumideros y \
las zonas donde los vectores divergen son manantiales. Es decir, el fluido \
fluye de los manantiales a los sumideros. La divergencia es una medida de la \
magnitud de un manantial o de un sumidero. \
\>", "Text"],

Cell["\<\
La siguiente gr\[AAcute]fica es una representaci\[OAcute]n por curvas de \
nivel de la divergencia del campo anterior.\
\>", "Text"],

Cell[BoxData[
    \(\(ContourPlot[
        Cos[x] - Sin[y], {x, \(-5\), 5}, {y, \(-8\), 5}];\)\)], "Input"],

Cell["\<\
En las zonas m\[AAcute]s claras la divergencia es positiva (fuentes o \
manantiales) y en las m\[AAcute]s oscuras es negativa (sumideros).\
\>", "Text"],

Cell["Veamos un ejemplo m\[AAcute]s. ", "Text"],

Cell[BoxData[{
    \(F[x_, y_] := {x\ Cos[y], \(-Sin[y]\)}\), "\n", 
    \(\(Show[
        Graphics[
          Table[{Red, 
              Arrow[{x, y}, {x, y} + F[x, y], \ HeadScaling\  -> \ Relative, 
                HeadWidth ->  .3]}, {x, \(-5\), 5,  .5}, {y, \(-5\), 
              5,  .5}]], Axes -> True, 
        ImageSize -> {437, \ 378}];\)\), "\n", 
    \(Clear[F]\)}], "Input"],

Cell[TextData[{
  "En esta gr\[AAcute]fica no hay puntos a los que ",
  StyleBox["desde todas las direcciones",
    FontSlant->"Italic"],
  " converjan o diverjan los vectores del campo. Aparentemente no hay fuentes \
ni sumideros. De hecho este campo tiene divergencia nula."
}], "Text"],

Cell[BoxData[
    \(D[x\ Cos[y], x] + D[\(-Sin[y]\), y]\)], "Input"],

Cell["\<\
A continuaci\[OAcute]n nos proponemos generalizar los conceptos anteriores. \
No hay dificultad ninguna en extender el concepto de divergencia para campos \
vectoriales de n variables.\
\>", "Text"],

Cell[TextData[{
  "Definici\[OAcute]n",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"F", 
              StyleBox[":",
                FontWeight->"Plain"], 
              StyleBox["A",
                FontWeight->"Plain"]}], 
            StyleBox["\[Rule]",
              FontWeight->"Plain"], 
            StyleBox[\(\[DoubleStruckCapitalR]\^n\),
              FontWeight->"Plain"]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " ",
  StyleBox[
  "un campo vectorial con derivadas parciales de primer orden definido en un \
abierto ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^n\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["x",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\((\(F\_1\)(x), \(F\_2\)(x),  ... , \(F\_n\)(x))\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[". Se llama divergencia de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" en un punto ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Plain"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[
                RowBox[{
                  SubscriptBox[
                    StyleBox["x",
                      FontWeight->"Plain"], "1"], ",", \(x\_2\), ",", "...", 
                  ",", \(x\_n\)}],
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["\[Element]",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " ",
  StyleBox["y se nota ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["div",
            FontWeight->"Plain"], " ", 
          RowBox[{"F", 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["x",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " ",
  StyleBox["al n\[UAcute]mero",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{"div", 
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]], 
          StyleBox[\((x)\),
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    SubscriptBox[
                      StyleBox["F",
                        FontSlant->"Italic"], "1"]}], \(\[PartialD]x\_1\)], 
                RowBox[{"(", 
                  StyleBox["x",
                    FontSlant->"Italic"], ")"}]}], "+", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    SubscriptBox[
                      StyleBox["F",
                        FontSlant->"Italic"], "2"]}], \(\[PartialD]x\_2\)], 
                RowBox[{"(", 
                  StyleBox["x",
                    FontSlant->"Italic"], ")"}]}], "+"}], "..."}], "+", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "n"]}], \(\[PartialD]x\_n\)], 
            RowBox[{"(", 
              StyleBox["x",
                FontSlant->"Italic"], ")"}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que la diveregcncia de un campo vectorial es un campo escalar. \
Suele usarse una notaci\[OAcute]n simb\[OAcute]lica para representar la \
divergencia. Para ello se define el ",
  StyleBox["operador nabla",
    FontSlant->"Italic"],
  ", \[Del], como"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Del]\(\(=\)\((\[PartialD]\/\[PartialD]x\_1, \
\[PartialD]\/\[PartialD]x\_2,  ... , \[PartialD]\/\[PartialD]x\_n)\)\)\)], \
"Text",
  TextAlignment->Center],

Cell[TextData[{
  "Este operador cuando act\[UAcute]a sobre un campo escalar, ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", produce su gradiente:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], "(", "x", ")"}]}], "=", 
        RowBox[{
          
          RowBox[{\((\[PartialD]\/\[PartialD]x\_1, \
\[PartialD]\/\[PartialD]x\_2,  ... , \[PartialD]\/\[PartialD]x\_n)\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], "(", "x", ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["f",
                      FontSlant->"Italic"]}], \(\[PartialD]x\_1\)], \((x)\)}],
               ",", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["f",
                      FontSlant->"Italic"]}], \(\[PartialD]x\_2\)], \((x)\)}],
               ",", "...", ",", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["f",
                      
                      FontSlant->
                        "Italic"]}], \(\[PartialD]x\_n\)], \((x)\)}]}], 
            ")"}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La divergencia de un campo vectorial ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en un punto ",
  StyleBox["x",
    FontSlant->"Italic"],
  " puede escribirse como el producto escalar simb\[OAcute]lico del vector \
\[Del] por el vector ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(",
  StyleBox["x",
    FontSlant->"Italic"],
  ")",
  StyleBox[".",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{"div", 
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]], 
          StyleBox[\((x)\),
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{"\[Del]", 
              RowBox[{
                StyleBox[".",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}], 
            StyleBox[\((x)\),
              FontSlant->"Italic"]}], 
          StyleBox["=",
            FontSlant->"Plain"], 
          RowBox[{
            
            RowBox[{\((\[PartialD]\/\[PartialD]x\_1, \
\[PartialD]\/\[PartialD]x\_2,  ... , \[PartialD]\/\[PartialD]x\_n)\), " ", 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox["(",
                  FontWeight->"Plain"], 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["F",
                          FontWeight->"Plain",
                          FontSlant->"Italic"], "1"],
                      FontWeight->"Plain"], "(", 
                    StyleBox["x",
                      FontWeight->"Plain",
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontWeight->"Plain"]}], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["F",
                          FontWeight->"Plain",
                          FontSlant->"Italic"], "2"],
                      FontWeight->"Plain"], "(", 
                    StyleBox["x",
                      FontWeight->"Plain",
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontWeight->"Plain"]}], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox["...",
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  RowBox[{
                    StyleBox[
                      SubscriptBox[
                        StyleBox["F",
                          FontWeight->"Plain",
                          FontSlant->"Italic"], "n"],
                      FontWeight->"Plain"], "(", 
                    StyleBox["x",
                      FontWeight->"Plain",
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontWeight->"Plain"]}]}], 
                StyleBox[")",
                  FontWeight->"Plain"]}]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        SubscriptBox[
                          StyleBox["F",
                            FontSlant->"Italic"], 
                          "1"]}], \(\[PartialD]x\_1\)], 
                    RowBox[{"(", 
                      StyleBox["x",
                        FontSlant->"Italic"], ")"}]}], "+", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        SubscriptBox[
                          StyleBox["F",
                            FontSlant->"Italic"], 
                          "2"]}], \(\[PartialD]x\_2\)], 
                    RowBox[{"(", 
                      StyleBox["x",
                        FontSlant->"Italic"], ")"}]}], "+"}], "..."}], "+", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    SubscriptBox[
                      StyleBox["F",
                        FontSlant->"Italic"], "n"]}], \(\[PartialD]x\_n\)], 
                RowBox[{"(", 
                  StyleBox["x",
                    FontSlant->"Italic"], ")"}]}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Comprobaremos m\[AAcute]s adelante que la divergencia de un campo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " tiene un significado f\[IAcute]sico que generaliza lo visto para el caso \
de campos bidimensionales."
}], "Text"],

Cell["\<\
Es conveniente enunciar ahora, para refercncia posterior, un resultado \
obtenido anteriormente como consecuencia del teorema de Green.\
\>", "Text"],

Cell[TextData[{
  "Teorema de la divergencia para campos en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]]
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "Sea \[Gamma] un camino cerrado simple positivamente orientado y ",
  StyleBox["D",
    FontSlant->"Italic"],
  " la regi\[OAcute]n del plano limitada por \[Gamma]. Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], ":", " ", "A"}], "\[Rule]", 
            \(\[DoubleStruckCapitalR]\^2\)}]}], TraditionalForm]]],
  " un campo vectorial de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "definido en un abierto que contiene a ",
  StyleBox["D",
    FontSlant->"Italic"],
  ". Notemos por ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " el vector normal unitario exterior a \[Gamma]. Entonces se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox["n",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["D",
                  FontSlant->"Italic"]], 
              RowBox[{"div", " ", 
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((x, 
                  y)\), \(\[DifferentialD]\((x, y)\)\)}]}]}]}]], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Nota. Este resultado puede generalizarse, al igual que el teorema de Green, \
para dominios con agujeros.\
\>", "Text"],

Cell[TextData[{
  "En el caso particular de que el campo ",
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontWeight->"Bold"], TraditionalForm]]],
  " sea el campo de gradiente de un campo escalar ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", \(\[Del]\ f\)}], TraditionalForm]]],
  ", la igualdad anterior nos dice que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          RowBox[{
            RowBox[{"\[Del]", 
              StyleBox["f",
                FontWeight->"Plain",
                FontSlant->"Italic"]}], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["n",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["D",
                  FontSlant->"Italic"]], 
              RowBox[{"div", " ", 
                RowBox[{"(", 
                  RowBox[{"\[Del]", 
                    StyleBox["f",
                      FontWeight->"Plain",
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontWeight->"Plain",
                    FontSlant->"Italic"]}], \((x, 
                  y)\), \(\[DifferentialD]\((x, y)\)\)}]}]}], "=", 
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["D",
                  FontSlant->"Italic"]], 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      FractionBox[
                        RowBox[{\(\[PartialD]\^2\), 
                          StyleBox["f",
                            FontSlant->"Italic"]}], 
                        RowBox[{"\[PartialD]", 
                          SuperscriptBox[
                            StyleBox["x",
                              FontSlant->"Italic"], "2"]}]], \((x, y)\)}], 
                    "+", 
                    RowBox[{
                      FractionBox[
                        RowBox[{\(\[PartialD]\^2\), 
                          StyleBox["f",
                            FontSlant->"Italic"]}], 
                        RowBox[{"\[PartialD]", 
                          SuperscriptBox[
                            StyleBox["y",
                              FontSlant->"Italic"], "2"]}]], \((x, y)\)}]}], 
                  ")"}], \(\[DifferentialD]\((x, y)\)\)}]}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el vector unitario normal exterior a \[Gamma], en cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " de \[Gamma] el producto escalar ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(x, y)\)\), 
          StyleBox[".",
            FontWeight->"Bold"], " ", 
          RowBox[{
            StyleBox["n",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox[\(x, y\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " es la derivada del campo escalar ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " en la direcci\[OAcute]n del vector unitario normal exterior a \[Gamma] en \
dicho punto y suele usarse la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Del]\(f(x, y)\)\), 
            StyleBox[".",
              FontWeight->"Bold"], " ", 
            RowBox[{
              StyleBox["n",
                FontWeight->"Bold"], "(", \(x, y\), ")"}]}], 
          "=", \(\(\[PartialD]f\/\[PartialD]n\) \((x, y)\)\)}], 
        TraditionalForm]]],
  ", con ello obtenemos la igualdad"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["f",
                  FontSlant->"Italic"]}], \(\[PartialD]n\)]}], "=", 
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["D",
                  FontSlant->"Italic"]], 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      FractionBox[
                        RowBox[{\(\[PartialD]\^2\), 
                          StyleBox["f",
                            FontSlant->"Italic"]}], 
                        RowBox[{"\[PartialD]", 
                          SuperscriptBox[
                            StyleBox["x",
                              FontSlant->"Italic"], "2"]}]], \((x, y)\)}], 
                    "+", 
                    RowBox[{
                      FractionBox[
                        RowBox[{\(\[PartialD]\^2\), 
                          StyleBox["f",
                            FontSlant->"Italic"]}], 
                        RowBox[{"\[PartialD]", 
                          SuperscriptBox[
                            StyleBox["y",
                              FontSlant->"Italic"], "2"]}]], \((x, y)\)}]}], 
                  ")"}], \(\[DifferentialD]\((x, y)\)\)}]}]}]}]], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La generalizaci\[OAcute]n del concepto de rotaci\[OAcute]n de un campo \
bidimensional vamos a hacerla para campos vectoriales en el espacio. Para \
ello nos vamos a guiar por un resultado que conocemos de la lecci\[OAcute]n \
anterior que afirma que una condici\[OAcute]n necesaria y suficiente para que \
un campo vectorial de dos variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  "definido en un abierto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  "sea localmente conservativo es que para todo ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Element] A\)]],
  " se verifique la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"]}]}], TextForm]]],
  " o, lo que es igual, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"]}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"]}]}], "=", "0"}], TextForm]]],
  " ; esto es, con la terminolog\[IAcute]a introducida m\[AAcute]s arriba, \
que el campo sea irrotacional. \nEl resultado an\[AAcute]logo para un campo \
de tres variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              StyleBox[\(P(x, y, z)\),
                FontWeight->"Plain"], 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
              StyleBox[\(Q(x, y, z)\),
                FontWeight->"Plain"], 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
              StyleBox[\(R(x, y, z)\),
                FontWeight->"Plain"], 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " establece las condiciones"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["R",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                StyleBox[\(x, y, z\),
                  FontSlant->"Italic"], ")"}]}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["z",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                StyleBox[\(x, y, z\),
                  FontSlant->"Italic"], ")"}]}]}], " ", "=", " ", 
          RowBox[{
            RowBox[{
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["P",
                      FontSlant->"Italic"]}], 
                  RowBox[{"\[PartialD]", 
                    StyleBox["z",
                      FontSlant->"Italic"]}]], 
                RowBox[{"(", 
                  StyleBox[\(x, y, z\),
                    FontSlant->"Italic"], ")"}]}], "-", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["R",
                      FontSlant->"Italic"]}], 
                  RowBox[{"\[PartialD]", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], 
                RowBox[{"(", 
                  StyleBox[\(x, y, z\),
                    FontSlant->"Italic"], ")"}]}]}], "   ", "=", 
            RowBox[{
              RowBox[{
                RowBox[{
                  FractionBox[
                    RowBox[{"\[PartialD]", 
                      StyleBox["Q",
                        FontSlant->"Italic"]}], 
                    RowBox[{"\[PartialD]", 
                      StyleBox["x",
                        FontSlant->"Italic"]}]], 
                  RowBox[{
                    StyleBox["(",
                      FontSlant->"Italic"], 
                    StyleBox[\(x, y, z\),
                      FontSlant->"Italic"], ")"}]}], "-", 
                RowBox[{
                  FractionBox[
                    RowBox[{"\[PartialD]", 
                      StyleBox["P",
                        FontSlant->"Italic"]}], 
                    RowBox[{"\[PartialD]", 
                      StyleBox["y",
                        FontSlant->"Italic"]}]], 
                  RowBox[{"(", 
                    StyleBox[\(x, y, z\),
                      FontSlant->"Italic"], ")"}]}]}], " ", "=", "0"}]}]}], 
        "        "}], TextForm]], "Text",
  TextAlignment->Center],

Cell["Estas ideas llevan a la siguiente definici\[OAcute]n.", "Text"],

Cell["Rotacional de un campo vectorial", "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              StyleBox[\(P(x, y, z)\),
                FontWeight->"Plain"], 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
              StyleBox[\(Q(x, y, z)\),
                FontWeight->"Plain"], 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{
              StyleBox[\(R(x, y, z)\),
                FontWeight->"Plain"], 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " un campo vectorial con derivadas parciales de primer orden definido en un \
abierto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^3\)]],
  ". Se define el rotacional de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] A\)]],
  " como el vector"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"rot", " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["(",
                FontWeight->"Bold",
                FontSlant->"Plain"], 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["R",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["y",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(x, y, z\),
                        FontSlant->"Italic"], ")"}]}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["Q",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["z",
                          FontSlant->"Italic"]}]], 
                    RowBox[{
                      StyleBox["(",
                        FontSlant->"Italic"], 
                      StyleBox[\(x, y, z\),
                        FontSlant->"Italic"], ")"}]}]}], ")"}], 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], "+", 
            RowBox[{
              RowBox[{"(", " ", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["P",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["z",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(x, y, z\),
                        FontSlant->"Italic"], ")"}]}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["R",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(x, y, z\),
                        FontSlant->"Italic"], ")"}]}]}], " ", ")"}], 
              StyleBox["j",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "+", " ", 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["Q",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(x, y, z\),
                        FontSlant->"Italic"], ")"}]}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["P",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["y",
                          FontSlant->"Italic"]}]], 
                    RowBox[{"(", 
                      StyleBox[\(x, y, z\),
                        FontSlant->"Italic"], ")"}]}]}], " ", ")"}], "  ", 
              StyleBox["k",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], "      "}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Se dice que un campo es ",
  StyleBox["irrotacional",
    FontWeight->"Bold"],
  " cuando su rotacional es id\[EAcute]nticamente nulo."
}], "Text"],

Cell["\<\
Para recordar esta definici\[OAcute]n se acostumbra a representar \
simbolicamente el rotacional por medio del operador nabla en tres dimensiones\
\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"\[Del]", 
        RowBox[{"=", 
          
          RowBox[{\((\[PartialD]\/\[PartialD]x, \[PartialD]\/\[PartialD]y, \
\[PartialD]\/\[PartialD]z)\), "=", 
            RowBox[{
              RowBox[{\(\[PartialD]\/\[PartialD]x\), 
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], " ", "+", 
              RowBox[{\(\[PartialD]\/\[PartialD]y\), 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], " ", "+", 
              RowBox[{\(\[PartialD]\/\[PartialD]z\), 
                StyleBox["k",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
con ello podemos escribir el rotacional como el siguiente producto vectorial \
simb\[OAcute]lico\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{"rot", " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["(",
                FontWeight->"Bold",
                FontSlant->"Plain"], 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            RowBox[{"\[Del]", 
              RowBox[{"\[Times]", 
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["(",
                    FontWeight->"Bold",
                    FontSlant->"Plain"], 
                  StyleBox[\(x, y, z\),
                    FontSlant->"Italic"], ")"}]}]}], "=", 
            RowBox[{
              RowBox[{"determinante", " ", 
                RowBox[{"(", "\[NegativeThinSpace]", GridBox[{
                      {
                        StyleBox["i",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox["j",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox["k",
                          FontWeight->"Bold",
                          FontSlant->"Italic"]},
                      {\(\[PartialD]\/\[PartialD]x\), 
                        \(\[PartialD]\/\[PartialD]y\), 
                        \(\[PartialD]\/\[PartialD]z\)},
                      {
                        StyleBox["P",
                          FontSlant->"Italic"], 
                        StyleBox["Q",
                          FontSlant->"Italic"], 
                        StyleBox["R",
                          FontSlant->"Italic"]}
                      }], "\[NegativeThinSpace]", ")"}]}], "=", 
              RowBox[{
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["R",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["y",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y, z\),
                            FontSlant->"Italic"], ")"}]}], "-", 
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["Q",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["z",
                              FontSlant->"Italic"]}]], 
                        RowBox[{
                          StyleBox["(",
                            FontSlant->"Italic"], 
                          StyleBox[\(x, y, z\),
                            FontSlant->"Italic"], ")"}]}]}], ")"}], 
                  StyleBox["i",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], "+", 
                RowBox[{
                  RowBox[{"(", " ", 
                    RowBox[{
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["P",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["z",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y, z\),
                            FontSlant->"Italic"], ")"}]}], "-", 
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["R",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["x",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y, z\),
                            FontSlant->"Italic"], ")"}]}]}], " ", ")"}], 
                  StyleBox["j",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], " ", "+", " ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["Q",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["x",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y, z\),
                            FontSlant->"Italic"], ")"}]}], "-", 
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["P",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["y",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y, z\),
                            FontSlant->"Italic"], ")"}]}]}], " ", ")"}], 
                  "  ", 
                  StyleBox["k",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}]}]}]}], "            "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Podemos tambi\[EAcute]n definir el rotacional de un campo de dos \
variables, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", por el convenio de asociar a dicho campo el campo de tres variables  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold"], "3"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{\(P(x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " y definir ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"rot", " ", 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}]}], "=", 
          RowBox[{"rot", " ", 
            FormBox[
              RowBox[{
                SubscriptBox[
                  StyleBox["F",
                    FontWeight->"Bold"], "3"], "(", \(x, y, z\), ")"}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". Con ello, se obtiene f\[AAcute]cilmente que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"rot", " ", 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(x, y\), ")"}]}], "=", 
            FormBox[
              RowBox[{" ", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["Q",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["x",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y\),
                            FontSlant->"Italic"], ")"}]}], "-", 
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["P",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["y",
                              FontSlant->"Italic"]}]], 
                        RowBox[{"(", 
                          StyleBox[\(x, y\),
                            FontSlant->"Italic"], ")"}]}]}], " ", ")"}], 
                  "  ", 
                  StyleBox["k",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}],
              "TextForm"]}]}], TraditionalForm]]],
  ". Observa que el teorema de Green puede escribirse en la forma:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{"\[Integral]", 
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["D",
                  FontSlant->"Italic"]], 
              RowBox[{"rot", " ", 
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{\((x, y)\), 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  StyleBox["k",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], \(\[DifferentialD]\((x, 
                    y)\)\)}]}]}]}]], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Comprobaremos m\[AAcute]s adelante que el rotacional de un campo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " tiene un significado f\[IAcute]sico que generaliza lo visto para el caso \
de campos bidimensionales."
}], "Text"],

Cell[TextData[{
  "De la definici\[OAcute]n dada se sigue que una condici\[OAcute]n necesaria \
y suficiente para que un campo vectorial de tres variables de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^1\)]],
  " sea localmente conservativo es que sea irrotacional. En consecuencia, el \
campo de gradiente de un campo escalar de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^2\)]],
  " es irrotacional, lo que suele expresarse en la forma ",
  Cell[BoxData[
      \(TraditionalForm\`rot\ \((\[Del]f)\) = 0. \)]],
  " Tambi\[EAcute]n se comprueba con facilidad que d",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"iv", " ", 
            RowBox[{"(", 
              RowBox[{"rot", " ", 
                StyleBox["F",
                  FontWeight->"Bold"]}], ")"}]}], "=", "0"}], 
        TraditionalForm]]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios", "ExerciseMain"],

Cell[TextData[{
  "Los ejercicios de esta lecci\[OAcute]n son los propuestos en el libro de \
James Stewart ",
  StyleBox["C\[AAcute]lculo Multivariable",
    FontSlant->"Italic"],
  " 4\.aa Ed. en la secci\[OAcute]n 16.5 (p\[AAcute]gina 1081) \
n\[UAcute]meros: 1-8, 12, 19, 23-29, 30, 31, 33, 34 y 36."
}], "Text"]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Rotacional y divergencia"], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Rotacional y divergencia"], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[2055, 65, 85, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[2143, 69, 86, 2, 71, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 85670, 2422}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 41, 0, 99, "Title"],
Cell[1798, 53, 188, 6, 102, "Author"],

Cell[CellGroupData[{
Cell[2011, 63, 41, 0, 93, "Section"],
Cell[2055, 65, 85, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2143, 69, 86, 2, 71, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2232, 73, 87, 2, 72, "Input",
  InitializationCell->True],
Cell[2322, 77, 676, 13, 210, "Input",
  InitializationCell->True],
Cell[3001, 92, 451, 10, 202, "Input",
  InitializationCell->True],
Cell[3455, 104, 1210, 22, 410, "Input",
  InitializationCell->True],
Cell[4668, 128, 461, 9, 242, "Input",
  InitializationCell->True],
Cell[5132, 139, 1229, 21, 384, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[6398, 165, 65, 0, 61, "Section"],
Cell[6466, 167, 227, 4, 67, "Text"],
Cell[6696, 173, 742, 23, 67, "Text"],
Cell[7441, 198, 1318, 35, 63, "Text"],
Cell[8762, 235, 3205, 86, 254, "Text"],
Cell[11970, 323, 72, 0, 41, "Text"],
Cell[12045, 325, 52, 1, 72, "Input"],
Cell[12100, 328, 456, 7, 119, "Text"],
Cell[12559, 337, 55, 1, 72, "Input"],
Cell[12617, 340, 5218, 130, 478, "Text"],
Cell[17838, 472, 1174, 32, 63, "Text"],
Cell[19015, 506, 2018, 64, 83, "Text"],
Cell[21036, 572, 349, 15, 41, "Text"],
Cell[21388, 589, 1936, 53, 63, "Text"],
Cell[23327, 644, 224, 8, 41, "Text"],
Cell[23554, 654, 4811, 117, 175, "Text"],
Cell[28368, 773, 478, 14, 68, "Text"],
Cell[28849, 789, 1939, 55, 62, "Text"],
Cell[30791, 846, 495, 8, 119, "Text"],
Cell[31289, 856, 49, 1, 72, "Input"],
Cell[31341, 859, 1197, 31, 150, "Text"],
Cell[32541, 892, 45, 0, 41, "Text"],
Cell[32589, 894, 2186, 58, 63, "Text"],
Cell[34778, 954, 113, 3, 41, "Text"],
Cell[34894, 959, 1180, 32, 63, "Text"],
Cell[36077, 993, 1342, 41, 101, "Text"],
Cell[37422, 1036, 97, 2, 41, "Text"],
Cell[37522, 1040, 380, 9, 228, "Input"],
Cell[37905, 1051, 674, 10, 145, "Text"],
Cell[38582, 1063, 142, 3, 41, "Text"],
Cell[38727, 1068, 107, 2, 72, "Input"],
Cell[38837, 1072, 162, 3, 41, "Text"],
Cell[39002, 1077, 47, 0, 41, "Text"],
Cell[39052, 1079, 388, 9, 228, "Input"],
Cell[39443, 1090, 288, 6, 67, "Text"],
Cell[39734, 1098, 68, 1, 72, "Input"],
Cell[39805, 1101, 208, 4, 67, "Text"],
Cell[40016, 1107, 2767, 93, 68, "Text"],
Cell[42786, 1202, 1449, 41, 61, "Text"],
Cell[44238, 1245, 290, 7, 67, "Text"],
Cell[44531, 1254, 194, 4, 61, "Text"],
Cell[44728, 1260, 162, 5, 41, "Text"],
Cell[44893, 1267, 1284, 36, 62, "Text"],
Cell[46180, 1305, 461, 19, 69, "Text"],
Cell[46644, 1326, 4415, 119, 61, "Text"],
Cell[51062, 1447, 282, 6, 67, "Text"],
Cell[51347, 1455, 159, 3, 67, "Text"],
Cell[51509, 1460, 168, 5, 41, "Text"],
Cell[51680, 1467, 791, 24, 94, "Text"],
Cell[52474, 1493, 964, 29, 73, "Text"],
Cell[53441, 1524, 129, 3, 41, "Text"],
Cell[53573, 1529, 465, 16, 67, "Text"],
Cell[54041, 1547, 2366, 63, 67, "Text"],
Cell[56410, 1612, 1395, 43, 99, "Text"],
Cell[57808, 1657, 1499, 38, 77, "Text"],
Cell[59310, 1697, 3860, 111, 225, "Text"],
Cell[63173, 1810, 2897, 78, 61, "Text"],
Cell[66073, 1890, 69, 0, 41, "Text"],
Cell[66145, 1892, 70, 1, 41, "Text"],
Cell[66218, 1895, 1366, 44, 68, "Text"],
Cell[67587, 1941, 3965, 101, 61, "Text"],
Cell[71555, 2044, 166, 5, 41, "Text"],
Cell[71724, 2051, 171, 4, 67, "Text"],
Cell[71898, 2057, 792, 20, 61, "Text"],
Cell[72693, 2079, 120, 3, 41, "Text"],
Cell[72816, 2084, 5848, 139, 148, "Text"],
Cell[78667, 2225, 3239, 88, 102, "Text"],
Cell[81909, 2315, 911, 26, 73, "Text"],
Cell[82823, 2343, 281, 6, 67, "Text"],
Cell[83107, 2351, 862, 23, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84006, 2379, 34, 0, 90, "ExerciseMain"],
Cell[84043, 2381, 316, 7, 67, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

